import { Controller } from '@hotwired/stimulus';

export default class extends Controller {
    static targets = ['input', 'result', 'submitButton'];

    connect() {

    }

    saveValue(event) {
        if (event.target.value !== '') {
            this.resultTarget.value += event.target.value;

            if (this.resultTarget.value.length >= 6) {
                this.submitButtonTarget.focus();
            } else {
                const currentIndex = this.inputTargets.indexOf(event.target);
                if (currentIndex < this.inputTargets.length - 1) {
                    const nextInput = this.inputTargets[currentIndex + 1];
                    nextInput.focus();
                }
            }
        }
    }
}
