import {Controller} from '@hotwired/stimulus';

export default class extends Controller {
    connect() {}

    show() {
        const
            twoFactorModal = new bootstrap.Modal(this.element.getAttribute('data-modal')),
            apiUrl = this.element.getAttribute('data-api');

        fetch(apiUrl)
            .then(response => response.json())
            .then(data => {
                const
                    imgPreview = document.getElementById('twoFactorQrPreview'),
                    tokenPreview = document.getElementById('twoFactorToken');

                imgPreview.src = data.qrCode;
                tokenPreview.innerHTML = data.token;

                twoFactorModal.show();
            })
            .catch(error => console.error(error));
    }
}
