

function setupTabTrigger(triggerEl) {
    const tabTrigger = new bootstrap.Tab(triggerEl);

    triggerEl.addEventListener('mouseenter', event => {
        event.preventDefault();
        tabTrigger.show();
    });

    triggerEl.addEventListener('click', event => {
        event.preventDefault();
        window.location.href = triggerEl.getAttribute('href');
    });
}

// Function to set up tab triggers for the existing DOM elements
function setupTabTriggers() {
    const triggerTabList = document.querySelectorAll('#menuTab a');
    triggerTabList.forEach(triggerEl => {
        setupTabTrigger(triggerEl);
    });
}

// Set up initial tab triggers
setupTabTriggers();

// Create a MutationObserver to watch for changes in the DOM
const observer = new MutationObserver(mutations => {
    // Handle DOM changes here
    setupTabTriggers();
});

// Start observing the DOM changes
observer.observe(document.documentElement, {
    childList: true,
    subtree: true,
});



window.addEventListener('scroll', function() {
    // Lehívjuk a böngésző ablakának görgetési pozícióját
    var scrollPosition = window.scrollY || document.documentElement.scrollTop || document.body.scrollTop || 0;

    // Az elem kiválasztása
    var dynamicElement = document.getElementById('header');

    // Ellenőrizzük, hogy a görgetési pozíció elérte-e a 50 képpontot
    if (scrollPosition > 50) {
        // Hozzáadjuk a newClass osztályt, ha igaz
        dynamicElement.classList.add('navbar-scrolled');
    } else {
        // Különben eltávolítjuk azt
        dynamicElement.classList.remove('navbar-scrolled');
    }
});


