<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Entity\User\User;
use App\Service\Command\CommandBusInterface;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

#[AsMessageHandler(handles: ChangePasswordWithToken::class, bus: 'command.bus')]
final readonly class ChangePasswordWithTokenHandler
{
    public function __construct(
        private ResetPasswordHelperInterface $resetPasswordHelper,
        private CommandBusInterface          $commandBus
    )
    {
    }

    public function __invoke(ChangePasswordWithToken $changePasswordWithToken): void
    {
        $token = $changePasswordWithToken->getToken();

        try {
            /** @var User $user */
            $user = $this->resetPasswordHelper->validateTokenAndFetchUser($token);
        } catch (ResetPasswordExceptionInterface) {
            throw new BadRequestHttpException('Unable to change password');
        }

        $this->commandBus->handle(new ChangeUserPassword($user->getEmail(), $changePasswordWithToken->getPassword(), true));

        $this->resetPasswordHelper->removeResetRequest($token);
    }
}
