<?php

declare(strict_types=1);

namespace App\Command\Portal\User;

use App\Entity\User\User;
use App\Event\User\UserVerifiedEvent;
use App\Repository\User\UserRepository;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;

#[AsMessageHandler(handles: VerifyUser::class, bus: 'command.bus')]
final readonly class VerifyUserHandler
{
    public function __construct(
        private UserRepository           $userRepository,
        private EventDispatcherInterface $eventDispatcher
    )
    {
    }

    public function __invoke(VerifyUser $verifyUser): void
    {
        $user = $this->userRepository->findByVerificationToken($verifyUser->getToken());

        if (!$user instanceof User) {
            throw new BadRequestHttpException('Invalid verification url');
        }

        $user->setVerificationToken(null);
        $user->setVerified(true);

        $this->userRepository->add($user, true);

        $this->eventDispatcher->dispatch(new UserVerifiedEvent($user));
    }
}
