<?php

namespace App\Components;

use App\Repository\Education\Lesson\LessonRepository;
use Symfony\UX\LiveComponent\Attribute\AsLiveComponent;
use Symfony\UX\LiveComponent\Attribute\LiveProp;
use Symfony\UX\LiveComponent\DefaultActionTrait;

#[AsLiveComponent]
class Search
{
    use DefaultActionTrait;

    #[LiveProp(writable: true)]
    public string $query = '';

    public function __construct(
        private LessonRepository $lessonRepository
    )
    {
    }

    public function getLessons(): array
    {
        return $this->lessonRepository->search($this->query);
    }
}
