<?php

namespace App\Controller\App;

use App\Entity\System\Message;
use App\Form\Education\App\MessageType;
use App\Repository\Education\Lesson\CategoryRepository;
use App\Repository\Education\Lesson\LessonRepository;
use App\Repository\System\Page\PageRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/leckek', name: 'lesson_')]
final class LessonController extends AbstractController
{
    public function __construct(
        private readonly LessonRepository $lessonRepository,
        private readonly CategoryRepository $categoryRepository,
        private readonly PaginatorInterface $paginator,
    )
    {
    }

    #[Route('', name: 'index')]
    public function index(Request $request): Response
    {
        $categories = $request->get('kategoria');

        $lessonQuery = $this->lessonRepository->findPublics($categories);
        $lessons = $this->paginator->paginate(
            $lessonQuery->getQuery(),
            $request->query->getInt('oldal', 1),
            5
        );

        return $this->render('portal/lesson/index.html.twig', [
            'lessons' => $lessons,
            'categories' => $this->categoryRepository->findPublics($request->getLocale())
        ]);
    }

    #[Route('/{lesson}', name: 'details')]
    public function details(Request $request, string $lesson): Response
    {
        return $this->render('portal/lesson/item.html.twig', [
            'lesson' => $this->lessonRepository->findOneBySlug($request->getLocale(), $lesson)
        ]);
    }

    #[Route('/kategoria/{category}', name: 'category')]
    public function category(Request $request, string $category): Response
    {
        return $this->render('portal/lesson/category.html.twig', [
            'category' => $this->categoryRepository->findOneBySlug($request->getLocale(), $category)
        ]);
    }


}
