<?php

declare(strict_types=1);

namespace App\Controller\Cms;

use App\Repository\Education\ApplyRepository;
use App\Service\Chart\ApplyChart;
use App\Service\Chart\CategoryChart;
use App\Service\Chart\ExamChart;
use App\Service\Chart\LessonChart;
use App\Service\Chart\MessageChart;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

final class CmsController extends AbstractController
{
    public function __construct(
        private readonly MessageChart  $messageChart,
        private readonly LessonChart  $lessonChart,
        private readonly ApplyChart  $applyChart,
        private readonly ExamChart  $examChart,
        private readonly CategoryChart  $categoryChart,
        private readonly ApplyRepository $applyRepository
    )
    {
    }

    #[Route('/', name: 'index')]
    public function index(): Response
    {
        $this->denyAccessUnlessGranted('ROLE_ADMIN');

        return $this->render('system/index.html.twig', [
            'applyChart' => $this->applyChart->create(),
            'lessonChart' => $this->lessonChart->create(),
            'messageChart' => $this->messageChart->create(),
            'examChart' => $this->examChart->create(),
            'categoryChart' => $this->categoryChart->create(),
            'exportableApplies' => $this->applyRepository->collectForExport()
        ]);
    }
}
