<?php

declare(strict_types=1);

namespace App\Controller\Cms\Education;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Education\Benefit\Benefit;
use App\Form\Education\BenefitType;
use App\Table\Education\BenefitTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/education/benefit', name: self::PREFIX)]
final class BenefitController extends BaseController
{
    final public const KEY = 'benefits';

    final public const PREFIX = 'education_benefit_';

    final public const ENTITY = Benefit::class;

    final public const FORM = BenefitType::class;

    final public const TABLE = BenefitTable::class;

    use CmsAction;
}
