<?php

declare(strict_types=1);

namespace App\Controller\Cms\Education;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Education\Lesson\Category;
use App\Form\Education\CategoryType;
use App\Table\Education\CategoryTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/education/lesson-category', name: self::PREFIX)]
final class CategoryController extends BaseController
{
    final public const KEY = 'categories';

    final public const PREFIX = 'education_lesson_category_';

    final public const ENTITY = Category::class;

    final public const FORM = CategoryType::class;

    final public const TABLE = CategoryTable::class;

    use CmsAction;
}
