<?php

declare(strict_types=1);

namespace App\Controller\Cms\Education;

use App\Controller\Cms\Abstract\BaseController;

use App\Entity\Education\Lesson\Lesson;
use App\Form\Education\LessonType;
use App\Table\Education\LessonTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/education/lesson', name: self::PREFIX)]
final class LessonController extends BaseController
{
    final public const KEY = 'lessons';

    final public const PREFIX = 'education_lesson_';

    final public const ENTITY = Lesson::class;

    final public const FORM = LessonType::class;

    final public const TABLE = LessonTable::class;

    use CmsAction;
}
