<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Transformer\DTO\Cms\ActivityTransformer;
use Doctrine\ORM\EntityManagerInterface;
use Gedmo\Loggable\Entity\LogEntry;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Routing\Annotation\Route;
use Twig\Environment;

#[Route('/system/activity', name: 'system_activity_')]
final class ActivityController extends AbstractController
{
    public function __construct(
        private readonly RequestStack           $requestStack,
        private readonly EntityManagerInterface $entityManager,
        private readonly ActivityTransformer    $activityTransformer,
        private readonly Environment            $twigEnvironment
    )
    {
        $filterCollection = $this->entityManager->getFilters();
        $filterCollection->disable('softdeleteable');
    }

    #[Route('/api', name: 'api_get', methods: ['POST'])]
    public function getAction(): JsonResponse
    {

        $request = $this->requestStack->getCurrentRequest();
        $data = $request->getContent();
        $data = json_decode($data, true, 512, JSON_THROW_ON_ERROR);

        $entity = $this->entityManager->getRepository(str_replace('/', '\\', (string)$data['objectClass']))->findOneById($data['objectId']);

        $activities = $this->entityManager->getRepository(LogEntry::class)->getLogEntries($entity);
        $activities = array_map($this->activityTransformer, $activities);

        $response = $this->twigEnvironment->render('system/components/activity/_list.html.twig', [
            'activities' => $activities
        ]);

        return new JsonResponse($response);
    }

    #[Route('/revert/{id}', name: 'revert', methods: ['POST', 'GET'])]
    public function revertAction(LogEntry $logEntry): RedirectResponse
    {
        $route = $this->requestStack->getCurrentRequest()->headers->get('referer');
        $entityManager = $this->entityManager;
        $entity = $entityManager->getRepository(str_replace('/', '\\', $logEntry->getObjectClass()))->findOneById($logEntry->getObjectId());
        $repo = $entityManager->getRepository(LogEntry::class);
        $repo->revert($entity, $logEntry->getVersion());
        $entityManager->persist($entity);
        $entityManager->flush();

        return $this->redirect($route);

    }

}
