<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Common\Category\Category;
use App\Form\Common\CategoryType;
use App\Table\System\CategoryTable;
use App\Traits\Route\CmsAction;
use App\Traits\Route\TreeAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/category', name: self::PREFIX)]
final class CategoryController extends BaseController
{
    use CmsAction, TreeAction;

    final public const KEY = 'categories';

    final public const PREFIX = 'system_category_';

    final public const ENTITY = Category::class;

    final public const FORM = CategoryType::class;

    final public const TABLE = CategoryTable::class;

}
