<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Common\Support\Faq;
use App\Form\Common\FaqType;
use App\Table\System\FaqTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/faq', name: self::PREFIX)]
final class FaqController extends BaseController
{
    use CmsAction;

    final public const KEY = 'faqs';

    final public const PREFIX = 'system_faq_';

    final public const ENTITY = Faq::class;

    final public const FORM = FaqType::class;

    final public const TABLE = FaqTable::class;
}
