<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\File\Exception\FileException;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\String\Slugger\SluggerInterface;

#[Route('/system/file', name: 'system_file_')]
final class FileController extends AbstractController
{
    public function __construct(
        private readonly ParameterBagInterface $parameterBag,
        private readonly SluggerInterface      $slugger
    )
    {

    }

    #[Route('/upload', name: 'upload')]
    public function uploadAction(Request $request): JsonResponse
    {

        $file = $request->files->get('image');
        $file = $request->files->get('file');

        if ($file) {
            $originalFilename = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
            $safeFilename = $this->slugger->slug($originalFilename);
            $fileName = strtolower($safeFilename->toString()) . '-' . uniqid() . '.' . $file->guessExtension();

            try {
                $file->move($this->getTargetDirectory(), $fileName);

                $response = [
                    'success' => 1,
                    'file' => [
                        'url' => $this->parameterBag->get('app.api_url') . '/uploads/editorjs/' . $fileName
                    ]
                ];

            } catch (FileException $e) {
                $response = [
                    'success' => 0,
                    'message' => $e->getMessage()
                ];
            }
        }

        return new JsonResponse($response);
    }

    private function getTargetDirectory(): string
    {
        return $this->parameterBag->get('kernel.project_dir') . '/public/uploads/editorjs';
    }

}
