<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\System\Message;
use App\Form\System\MessageType;
use App\Table\System\MessageTable;
use App\Traits\Route\CmsAction;
use App\Traits\Route\ListAction;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/message', name: self::PREFIX)]
final class MessageController extends BaseController
{
    use ListAction;

    final public const KEY = 'messages';

    final public const PREFIX = 'system_message_';

    final public const ENTITY = Message::class;

    final public const FORM = MessageType::class;

    final public const TABLE = MessageTable::class;


    #[Route('/{id}/preview', name: 'preview')]
    public function previewAction(Message $message): Response
    {
        return $this->render('event/message_preview.html.twig', [
            'message' => $message
        ]);
    }

}
