<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Common\Tag\Tag;
use App\Form\Common\TagType;
use App\Table\System\TagTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/tag', name: self::PREFIX)]
final class TagController extends BaseController
{
    use CmsAction;

    final public const KEY = 'tags';

    final public const PREFIX = 'system_tag_';

    final public const ENTITY = Tag::class;

    final public const FORM = TagType::class;

    final public const TABLE = TagTable::class;
}
