<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\Common\Support\Topic;
use App\Form\Common\TopicType;
use App\Table\System\TopicTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/topic', name: self::PREFIX)]
final class TopicController extends BaseController
{
    use CmsAction;

    final public const KEY = 'topics';

    final public const PREFIX = 'system_topic_';

    final public const ENTITY = Topic::class;

    final public const FORM = TopicType::class;

    final public const TABLE = TopicTable::class;
}
