<?php

declare(strict_types=1);

namespace App\Controller\Cms\System;

use App\Controller\Cms\Abstract\BaseController;
use App\Entity\System\Webspace\Webspace;
use App\Form\System\Webspace\WebspaceType;
use App\Table\System\WebspaceTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/webspace', name: self::PREFIX)]
final class WebspaceController extends BaseController
{
    use CmsAction;

    final public const KEY = 'webspaces';

    final public const PREFIX = 'system_webspace_';

    final public const ENTITY = Webspace::class;

    final public const FORM = WebspaceType::class;

    final public const TABLE = WebspaceTable::class;
}
