<?php

declare(strict_types=1);

namespace App\Controller\Cms\User;

use App\Command\Portal\User\ResendVerification;
use App\Controller\Cms\Abstract\BaseController;
use App\Entity\User\User;
use App\Form\User\ChangePasswordType;
use App\Form\User\UserType;
use App\Service\Command\CommandBusInterface;
use App\Table\User\UserTable;
use App\Traits\Route\CmsAction;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/system/user', name: self::PREFIX)]
final class UserController extends BaseController
{
    use CmsAction;

    final public const KEY = 'portal_users';

    final public const PREFIX = 'user_';

    final public const ENTITY = User::class;

    final public const FORM = UserType::class;

    final public const TABLE = UserTable::class;

    #[Route('/{id}/resend-verification', name: 'resend_verification', methods: ['POST'])]
    public function resendNotification(User $user, CommandBusInterface $commandBus): Response
    {
        $commandBus->handle(new ResendVerification($user->getEmail()));

        $this->addFlash('success', 'verification_resent');

        return $this->redirectToRoute($this->prefix . 'list', [], Response::HTTP_SEE_OTHER);
    }

    #[Route('/{id}/password-change', name: 'change_password', methods: ['GET', 'POST'])]
    public function passwordChange(Request $request, User $user): Response
    {

        $form = $this->createForm(ChangePasswordType::class, $user, ['locale' => $request->getLocale()]);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $this->entityManager->flush();
            return $this->redirectToRoute($this->prefix . 'list', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('system/common/manage.html.twig', [
            'entity' => $user,
            'meta' => ['name' => $this->name, 'route_prefix' => $this->prefix],
            'form' => $form,
        ]);
    }
}
