<?php

namespace App\Controller\Portal\Auth\Login\Google;

use App\Service\Social\GoogleClient;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/auth/login/google/authorization-url', name: 'auth_login_google_authorization_url', methods: ['GET'])]
class AuthorizationUrlController extends AbstractController
{
    public function __construct(
        private readonly GoogleClient         $client,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(): Response
    {
        return $this->viewHandler->handle([
            'url' => $this->client->getUrl(),
        ]);
    }
}