<?php

namespace App\Controller\Portal\Auth\PasswordReset;

use App\Command\Portal\User\RequestPasswordChange as RequestPasswordChangeCommand;
use App\DTO\PublicAPI\User\Input\RequestPasswordChange;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/auth/password-reset/reset', name: 'auth_password_reset_reset', methods: ['POST'])]
class RequestController extends AbstractController
{
    public function __construct(
        private readonly CommandBusInterface  $commandBus,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(#[MapRequestPayload] RequestPasswordChange $requestPasswordChange): Response
    {
        $this->commandBus->handle(new RequestPasswordChangeCommand($requestPasswordChange->email));

        return $this->viewHandler->handle([]);
    }
}