<?php

declare(strict_types=1);

namespace App\Controller\Portal\Faq;

use App\DTO\PublicAPI\Shared\Input\FaqFilter;
use App\Repository\Common\FaqRepository;
use App\Service\Pagination\Context\PaginationContextInterface;
use App\Service\View\Context\ViewContext;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\Shared\FaqTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/faqs', name: 'faq_list', methods: ['GET'])]
final class ListController extends AbstractController
{
    public function __construct(
        private readonly FaqRepository        $faqRepository,
        private readonly FaqTransformer       $faqTransformer,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(Request $request, PaginationContextInterface $paginationContext, FaqFilter $filter): Response
    {
        $faqs = $this->faqRepository->findPublicFaqs(
            $request->getLocale(),
            $paginationContext,
            $filter,
        );

        $faqs = array_map($this->faqTransformer, $faqs);

        return $this->viewHandler->handle($faqs, new ViewContext(extra: [
            'pagination' => $paginationContext
        ]));
    }

}
