<?php

declare(strict_types=1);

namespace App\Controller\Portal\Page;

use App\Entity\System\Page\Page;
use App\Repository\System\Page\PageRepository;
use App\Service\View\ViewHandlerInterface;
use App\Transformer\DTO\Page\PageDetailsTransformer;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/pages/{slug}', name: 'page_view', methods: ['GET'])]
final class ViewController extends AbstractController
{
    public function __construct(
        private readonly PageRepository         $pageRepository,
        private readonly PageDetailsTransformer $pageDetailsTransformer,
        private readonly ViewHandlerInterface   $viewHandler
    )
    {
    }

    public function __invoke(Request $request, string $slug): Response
    {
        $transformer = $this->pageDetailsTransformer;
        $page = $this->pageRepository->findOneBySlug($request->getLocale(), $slug);
        $page = $transformer($page);

        return $this->viewHandler->handle($page);
    }
}
