<?php

declare(strict_types=1);

namespace App\Controller\Portal\Profile;

use App\Command\Portal\User\ModifyUser as ModifyUserCommand;
use App\DTO\PublicAPI\User\Input\ModifyUser;
use App\Entity\User\User;
use App\Service\Command\CommandBusInterface;
use App\Service\View\ViewHandlerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Attribute\MapRequestPayload;
use Symfony\Component\Routing\Annotation\Route;

#[Route(path: '/profile', name: 'profile_edit', methods: ['PUT'])]
final class EditController extends AbstractController
{
    public function __construct(
        private readonly Security             $security,
        private readonly CommandBusInterface  $commandBus,
        private readonly ViewHandlerInterface $viewHandler
    )
    {
    }

    public function __invoke(#[MapRequestPayload] ModifyUser $modifyUser): Response
    {
        /** @var User $user */
        $user = $this->security->getUser();

        $this->commandBus->handle(new ModifyUserCommand(
            $user->getId()->toRfc4122(),
            $modifyUser->name,
            $modifyUser->newPassword
        ));

        return $this->viewHandler->handle([]);
    }
}
