<?php

declare(strict_types=1);

namespace App\DTO\Cms;

use DateTime;

final readonly class Activity
{
    public function __construct(
        public int      $id,
        public string   $action,
        public DateTime $loggedAt,
        public string   $objectId,
        public string   $objectClass,
        public int      $version,
        public ?array   $data,
        public ?array   $administrator,
    )
    {
    }
}
