<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\Article\Output;

use App\DTO\PublicAPI\Shared\Output\Media;
use App\DTO\PublicAPI\Shared\Output\Meta;
use DateTimeInterface;
use Symfony\Component\Uid\Uuid;

final readonly class ArticleDetails
{
    public function __construct(
        public ?Uuid              $id,
        public ?string            $title,
        public ?string            $lead,
        public string             $slug,
        public bool               $highlighted,
        public ?DateTimeInterface $publishedAt,
        public ?Media             $media,
        public ?Meta              $meta,
        public ?array             $content,
    )
    {
    }
}
