<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\Shared\Output;

use App\Enum\Shared\AddressType;
use Symfony\Component\Uid\Uuid;

final readonly class Address
{
    public function __construct(
        public Uuid        $id,
        public AddressType $type,
        public string      $country,
        public string      $zip,
        public string      $city,
        public string      $street,
        public string      $streetType,
        public string      $houseNumber,
        public ?string     $building,
        public ?string     $floor,
        public ?string     $door,
    )
    {
    }
}
