<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\User\Input;

use App\DTO\Shared\Input\RecaptchaTrait;
use Symfony\Component\Validator\Constraints as Assert;

final class FormLogin
{
    use RecaptchaTrait;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Email(),
        new Assert\Length(min: 3, max: 255)
    ])]
    public $username;

    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Length(min: 1, max: 255)
    ])]
    public $password;
}
