<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\User\Input;

use App\Validator\Constraints\Password;
use Symfony\Component\Security\Core\Validator\Constraints\UserPassword;
use Symfony\Component\Validator\Constraints as Assert;

final class ModifyUser
{
    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Length(min: 3, max: 255),
    ])]
    public $name;

    #[Assert\When(
        expression: '(this.password ?: "") !== ""',
        constraints: [
            new Assert\Sequentially([
                new Assert\Type('string'),
                new UserPassword(),
            ])
        ]
    )]
    public $password;

    #[Assert\When(
        expression: '(this.password ?: "") !== ""',
        constraints: [
            new Assert\Sequentially([
                new Assert\NotBlank(),
                new Assert\Type('string'),
                new Password(),
                new Assert\Length(min: 8, max: 255)
            ])
        ]
    )]
    public $newPassword;
}
