<?php

declare(strict_types=1);

namespace App\DTO\PublicAPI\User\Input;

use Symfony\Component\Validator\Constraints as Assert;

final class VerifyUser
{
    #[Assert\Sequentially([
        new Assert\NotBlank(),
        new Assert\Type('string'),
        new Assert\Length(min: 1, max: 255)
    ])]
    public $token;
}
