<?php

declare(strict_types=1);

namespace App\DTO\Shared\Input;

use App\Validator\Constraints\Recaptcha;
use Symfony\Component\Validator\Constraints as Assert;

trait RecaptchaTrait
{
    #[Assert\Sequentially([
        new Assert\Type('string'),
        new Recaptcha()
    ])]
    public $recaptcha;
}
