<?php

namespace App\DependencyInjection;

use App\Service\Image\PresetRegistry;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Extension\Extension;

class SimpleExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration(new Configuration(), $configs);

        $presets = $config['images']['presets'] ?? [];

        $definition = new Definition(PresetRegistry::class);

        foreach ($presets as $name => $parameters) {
            $definition->addMethodCall('addPreset', [$name, $parameters]);
        }

        $container->setDefinition('app.image.preset_registry', $definition);
    }
}