<?php

declare(strict_types=1);

namespace App\Entity\Common;

use App\Entity\Shared\AbstractEntity;
use App\Enum\Shared\AddressType;
use App\Repository\Common\AddressRepository;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('system_address')]
#[ORM\Entity(repositoryClass: AddressRepository::class)]
class Address extends AbstractEntity
{
    #[ORM\Column(length: 50)]
    #[Gedmo\Versioned]
    private ?string $zip = null;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $city = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $street = null;

    #[ORM\Column(length: 100, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $streetType = null;

    #[ORM\Column(length: 100, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $houseNumber = null;

    #[ORM\Column(length: 50, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $floor = null;

    #[ORM\Column(length: 50, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $door = null;

    #[ORM\Column(length: 50, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $building = null;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $country = null;

    #[ORM\Column(length: 255, enumType: AddressType::class)]
    #[Gedmo\Versioned]
    private ?AddressType $type = null;


    public function getZip(): ?string
    {
        return $this->zip;
    }

    public function setZip(string $zip): self
    {
        $this->zip = $zip;

        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(string $city): self
    {
        $this->city = $city;

        return $this;
    }

    public function getStreet(): ?string
    {
        return $this->street;
    }

    public function setStreet(?string $street): self
    {
        $this->street = $street;

        return $this;
    }

    public function getStreetType(): ?string
    {
        return $this->streetType;
    }

    public function setStreetType(?string $streetType): self
    {
        $this->streetType = $streetType;

        return $this;
    }

    public function getHouseNumber(): ?string
    {
        return $this->houseNumber;
    }

    public function setHouseNumber(?string $houseNumber): self
    {
        $this->houseNumber = $houseNumber;

        return $this;
    }

    public function getFloor(): ?string
    {
        return $this->floor;
    }

    public function setFloor(?string $floor): self
    {
        $this->floor = $floor;

        return $this;
    }

    public function getDoor(): ?string
    {
        return $this->door;
    }

    public function setDoor(?string $door): self
    {
        $this->door = $door;

        return $this;
    }

    public function getBuilding(): ?string
    {
        return $this->building;
    }

    public function setBuilding(?string $building): self
    {
        $this->building = $building;

        return $this;
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    public function setCountry(string $country): self
    {
        $this->country = $country;

        return $this;
    }

    public function getType(): ?AddressType
    {
        return $this->type;
    }

    public function setType(AddressType $type): self
    {
        $this->type = $type;

        return $this;
    }
}
