<?php

declare(strict_types=1);

namespace App\Entity\Common\Meta;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ImageAware;
use App\Traits\Entity\Sluggable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('common_meta_translation')]
class MetaTranslation extends AbstractTranslationEntity
{
    use Sluggable, ImageAware;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $siteName = null;

    #[ORM\Column(length: 160, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $description = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $keywords = null;

    public function getSiteName(): ?string
    {
        return $this->siteName;
    }

    public function setSiteName(?string $siteName): self
    {
        $this->siteName = $siteName;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getKeywords(): ?string
    {
        return $this->keywords;
    }

    public function setKeywords(?string $keywords): self
    {
        $this->keywords = $keywords;

        return $this;
    }
}
