<?php

declare(strict_types=1);

namespace App\Entity\Common\Tag;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('system_tag_translation')]
class TagTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable;

    #[ORM\Column(length: 255, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $image = null;

    public function getImage(): ?string
    {
        return $this->image;
    }

    public function setImage(?string $image): self
    {
        $this->image = $image;

        return $this;
    }
}
