<?php

declare(strict_types=1);

namespace App\Entity\Education;

use App\Entity\Education\Lesson\Category;
use App\Entity\Shared\AbstractEntity;
use App\Repository\Education\ApplyRepository;
use App\Traits\Entity\NameAware;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('education_apply')]
#[ORM\Entity(repositoryClass: ApplyRepository::class)]
class Apply extends AbstractEntity
{
    use NameAware;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $email = null;

    #[ORM\ManyToMany(targetEntity: Category::class, inversedBy: 'applies')]
    #[ORM\JoinTable('education_apply_to_category')]
    private Collection $categories;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $exportedAt = null;

    #[ORM\Column(options: ['default' => false])]
    private ?bool $isVerified = false;

    public function __construct()
    {
        $this->categories = new ArrayCollection();
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): static
    {
        $this->email = $email;
        return $this;
    }

    public function getCategories(): Collection
    {
        return $this->categories;
    }

    public function addCategory(Category $category): static
    {
        if (!$this->categories->contains($category)) {
            $this->categories->add($category);
        }

        return $this;
    }

    public function removeCategory(Category $category): static
    {
        $this->categories->removeElement($category);

        return $this;
    }

    public function getExportedAt(): ?\DateTimeImmutable
    {
        return $this->exportedAt;
    }

    public function setExportedAt(?\DateTimeImmutable $exportedAt): static
    {
        $this->exportedAt = $exportedAt;

        return $this;
    }

    public function getIsVerified(): ?bool
    {
        return $this->isVerified;
    }

    public function setIsVerified(bool $isVerified): static
    {
        $this->isVerified = $isVerified;

        return $this;
    }
}
