<?php

declare(strict_types=1);

namespace App\Entity\Education\Benefit;

use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\Education\BenefitRepository;
use App\Traits\Entity\ImageAware;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('education_benefit')]
#[ORM\Entity(repositoryClass: BenefitRepository::class)]
class Benefit extends AbstractTranslatableEntity
{
    use ImageAware;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $imageHighlighted = null;

    public function getImageHighlighted(): ?string
    {
        return $this->imageHighlighted;
    }

    public function setImageHighlighted(?string $imageHighlighted): self
    {
        $this->imageHighlighted = $imageHighlighted;

        return $this;
    }
}
