<?php

declare(strict_types=1);

namespace App\Entity\Education\Lesson;

use App\Entity\Shared\AbstractTranslationEntity;
use App\Traits\Entity\ContentAware;
use App\Traits\Entity\HighlightedAware;
use App\Traits\Entity\Publishable;
use App\Traits\Entity\Sluggable;
use App\Traits\Entity\Stateable;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Entity]
#[ORM\Table('education_lesson_translation')]
class LessonTranslation extends AbstractTranslationEntity
{
    use Sluggable, Stateable, HighlightedAware, Publishable, ContentAware;

    #[ORM\Column(length: 450, nullable: true)]
    #[Gedmo\Versioned]
    private ?string $intro = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $pdf = null;

    #[ORM\Column(length: 255, nullable: true)]
    private ?string $preview = null;

    public function getIntro(): ?string
    {
        return $this->intro;
    }

    public function setIntro(?string $intro): self
    {
        $this->intro = $intro;

        return $this;
    }

    public function getPdf(): ?string
    {
        return $this->pdf;
    }

    public function setPdf(?string $pdf): static
    {
        $this->pdf = $pdf;

        return $this;
    }

    public function getPreview(): ?string
    {
        return $this->preview;
    }

    public function setPreview(?string $preview): static
    {
        $this->preview = $preview;

        return $this;
    }
}
