<?php

declare(strict_types=1);

namespace App\Entity\Interfaces;

use Doctrine\Common\Collections\Collection;

interface NestedableInterface
{
    public function getPosition(): int;

    public function setPosition(int $position): void;

    public function getChildren(): Collection;

    public function setChildren(self $children): void;

    public function getParent(): ?self;

    public function setParent(NestedableInterface $nestedable): void;

    public function getRoot(): ?self;
}
