<?php

declare(strict_types=1);

namespace App\Entity\System\Administrator;

use App\Entity\Shared\AbstractEntity;
use App\Repository\System\Administrator\ResetPasswordRequestRepository;
use Doctrine\ORM\Mapping as ORM;
use SymfonyCasts\Bundle\ResetPassword\Model\ResetPasswordRequestInterface;
use SymfonyCasts\Bundle\ResetPassword\Model\ResetPasswordRequestTrait;

#[ORM\Entity(repositoryClass: ResetPasswordRequestRepository::class)]
class ResetPasswordRequest extends AbstractEntity implements ResetPasswordRequestInterface
{
    use ResetPasswordRequestTrait;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private ?Administrator $user = null;

    public function __construct(Administrator $administrator, \DateTimeInterface $expiresAt, string $selector, string $hashedToken)
    {
        $this->user = $administrator;
        $this->initialize($expiresAt, $selector, $hashedToken);
    }

    public function getUser(): object
    {
        return $this->user;
    }
}
