<?php

declare(strict_types=1);

namespace App\Entity\System\Webspace;

use App\Entity\Shared\AbstractTranslatableEntity;
use App\Repository\System\Webspace\ConfigRepository;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

#[ORM\Table('system_webspace_config')]
#[ORM\Entity(repositoryClass: ConfigRepository::class)]
class Config extends AbstractTranslatableEntity
{
    #[ORM\ManyToOne(inversedBy: 'configs')]
    #[ORM\JoinColumn(nullable: true)]
    private ?Webspace $webspace = null;

    #[ORM\Column(length: 255)]
    #[Gedmo\Versioned]
    private ?string $key = null;

    public function getWebspace(): ?Webspace
    {
        return $this->webspace;
    }

    public function setWebspace(?Webspace $webspace): self
    {
        $this->webspace = $webspace;

        return $this;
    }

    public function getKey(): ?string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }
}
