<?php

declare(strict_types=1);

namespace App\Entity\User;


use App\Entity\Shared\AbstractEntity;
use DateTimeInterface;
use Doctrine\ORM\Mapping as ORM;
use SymfonyCasts\Bundle\ResetPassword\Model\ResetPasswordRequestInterface;
use SymfonyCasts\Bundle\ResetPassword\Model\ResetPasswordRequestTrait;

#[ORM\Entity]
class UserResetPasswordRequest extends AbstractEntity implements ResetPasswordRequestInterface
{
    use ResetPasswordRequestTrait;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    private ?User $user = null;

    public function getUser(): User
    {
        return $this->user;
    }

    public function setUser(?User $user): void
    {
        $this->user = $user;
    }

    public function setPayload(
        DateTimeInterface $expiresAt,
        string            $selector,
        string            $hashedToken
    ): void
    {
        $this->initialize($expiresAt, $selector, $hashedToken);
    }
}
