<?php

declare(strict_types=1);

namespace App\Event\User;

use App\Entity\User\User;
use Symfony\Contracts\EventDispatcher\Event;

final class UserPasswordChangedEvent extends Event
{
    public function __construct(
        private readonly User $user,
        private readonly bool $sendEmail
    )
    {
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function shouldSendEmail(): bool
    {
        return $this->sendEmail;
    }
}
