<?php

declare(strict_types=1);

namespace App\Event\User;

use App\Entity\User\User;
use App\Enum\User\RegistrationSource;
use Symfony\Contracts\EventDispatcher\Event;

final class UserRegisteredEvent extends Event
{
    public function __construct(
        private readonly User               $user,
        private readonly RegistrationSource $source
    )
    {
    }

    public function getUser(): User
    {
        return $this->user;
    }

    public function getSource(): RegistrationSource
    {
        return $this->source;
    }
}
