<?php

declare(strict_types=1);

namespace App\EventSubscriber\Portal\Email;

use App\Event\User\UserVerifiedEvent;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

final readonly class UserVerifiedEmailEventSubscriber implements EventSubscriberInterface
{
    public function __construct(
        private TranslatorInterface $translator,
        private MailerInterface     $mailer
    )
    {
    }

    public static function getSubscribedEvents(): array
    {
        return [
            UserVerifiedEvent::class => 'handle'
        ];
    }

    public function handle(UserVerifiedEvent $userVerifiedEvent): void
    {
        $templatedEmail = (new TemplatedEmail())
            ->to($userVerifiedEvent->getUser()->getEmail())
            ->subject($this->translator->trans('Successful verification and welcome'))
            ->htmlTemplate('email/user_verified.html.twig')
            ->context([
                'name' => $userVerifiedEvent->getUser()->getFirstName(),
            ]);
        $this->mailer->send($templatedEmail);
    }
}
