<?php

namespace App\EventSubscriber\System;

use App\Entity\Common\Address;
use App\Entity\Interfaces\AddressableInterface;
use Doctrine\Bundle\DoctrineBundle\EventSubscriber\EventSubscriberInterface;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use ReflectionClass;

final class AddressableEventSubscriber implements EventSubscriberInterface
{
    private const ADDRESS = 'addresses';

    private const ADDRESS_ENTITY = Address::class;

    public function loadClassMetadata(LoadClassMetadataEventArgs $loadClassMetadataEventArgs): void
    {
        $classMetadata = $loadClassMetadataEventArgs->getClassMetadata();

        if (!$classMetadata->reflClass instanceof ReflectionClass) {
            return;
        }

        if (!is_a($classMetadata->reflClass->getName(), AddressableInterface::class, true)) {
            return;
        }

        $this->mapEntity($classMetadata);
    }

    private function mapEntity(ClassMetadataInfo $classMetadataInfo): void
    {
        if (class_exists(self::ADDRESS_ENTITY)) {
            $this->mapManyToManyBlock($classMetadataInfo);
        }
    }

    private function mapManyToManyBlock(ClassMetadataInfo $classMetadataInfo): void
    {
        $this->mapManyToManyWithTargetEntity($classMetadataInfo);
    }

    private function mapManyToManyWithTargetEntity(ClassMetadataInfo $classMetadataInfo): void
    {

        if ($classMetadataInfo->hasAssociation(self::ADDRESS)) {
            return;
        }

        $tableName = $classMetadataInfo->table['name'];

        $classMetadataInfo->mapManyToMany([
            'fieldName' => self::ADDRESS,
            'targetEntity' => self::ADDRESS_ENTITY,

            'joinTable' => [
                'name' => $tableName . '_to_address',
            ],
            'cascade' =>
                [
                    'persist'
                ]
        ]);
    }


    public function getSubscribedEvents(): array
    {
        return [Events::loadClassMetadata];
    }
}
