<?php

namespace App\EventSubscriber\System;

use App\Entity\Common\Meta\Meta;
use App\Entity\Interfaces\MetableInterface;
use Doctrine\Bundle\DoctrineBundle\EventSubscriber\EventSubscriberInterface;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use ReflectionClass;

final class MetableEventSubscriber implements EventSubscriberInterface
{
    private const META = 'meta';

    private const METABLE_ENTITY = Meta::class;

    public function loadClassMetadata(LoadClassMetadataEventArgs $loadClassMetadataEventArgs): void
    {
        $classMetadata = $loadClassMetadataEventArgs->getClassMetadata();

        if (!$classMetadata->reflClass instanceof ReflectionClass) {
            return;
        }

        if (!is_a($classMetadata->reflClass->getName(), MetableInterface::class, true)) {
            return;
        }

        $this->mapEntity($classMetadata);
    }

    private function mapEntity(ClassMetadataInfo $classMetadataInfo): void
    {
        if (class_exists(self::METABLE_ENTITY)) {
            $this->mapManyToOneMeta($classMetadataInfo);
        }
    }

    private function mapManyToOneMeta(ClassMetadataInfo $classMetadataInfo): void
    {
        $this->mapManyToOneWithTargetEntity($classMetadataInfo);
    }

    private function mapManyToOneWithTargetEntity(ClassMetadataInfo $classMetadataInfo): void
    {
        if ($classMetadataInfo->hasAssociation(self::META)) {
            return;
        }

        $classMetadataInfo->mapManyToOne([
            'fieldName' => self::META,
            'targetEntity' => self::METABLE_ENTITY,
            'cascade' =>
                [
                    'persist',
                    'remove'
                ]
        ]);
    }


    public function getSubscribedEvents(): array
    {
        return [Events::loadClassMetadata];
    }
}
