<?php

namespace App\EventSubscriber\System;

use App\Entity\Common\Tag\Tag;
use App\Entity\Interfaces\TagableInterface;
use Doctrine\Bundle\DoctrineBundle\EventSubscriber\EventSubscriberInterface;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use ReflectionClass;

final class TagableEventSubscriber implements EventSubscriberInterface
{
    private const TAG = 'tags';

    private const TAGABLE_ENTITY = Tag::class;

    public function loadClassMetadata(LoadClassMetadataEventArgs $loadClassMetadataEventArgs): void
    {
        $classMetadata = $loadClassMetadataEventArgs->getClassMetadata();

        if (!$classMetadata->reflClass instanceof ReflectionClass) {
            return;
        }

        if (!is_a($classMetadata->reflClass->getName(), TagableInterface::class, true)) {
            return;
        }

        $this->mapEntity($classMetadata);
    }

    private function mapEntity(ClassMetadataInfo $classMetadataInfo): void
    {
        if (class_exists(self::TAGABLE_ENTITY)) {
            $this->mapManyToManyBlock($classMetadataInfo);
        }
    }

    private function mapManyToManyBlock(ClassMetadataInfo $classMetadataInfo): void
    {
        $this->mapManyToManyWithTargetEntity($classMetadataInfo);
    }

    private function mapManyToManyWithTargetEntity(ClassMetadataInfo $classMetadataInfo): void
    {

        if ($classMetadataInfo->hasAssociation(self::TAG)) {
            return;
        }

        $tableName = $classMetadataInfo->table['name'];

        $classMetadataInfo->mapManyToMany([
            'fieldName' => self::TAG,
            'targetEntity' => self::TAGABLE_ENTITY,

            'joinTable' => [
                'name' => $tableName . '_to_tag',
            ],
            'cascade' =>
                [
                    'persist'
                ]
        ]);
    }


    public function getSubscribedEvents(): array
    {
        return [Events::loadClassMetadata];
    }
}
