<?php

declare(strict_types=1);

namespace App\Form\Abstract;

use App\Entity\Interfaces\BlockableInterface;
use App\Entity\Interfaces\MetableInterface;
use App\Entity\Interfaces\TagableInterface;
use App\Entity\Interfaces\TranslatableInterface;
use App\Form\Common\BlockType;
use App\Form\Common\MetaType;
use App\Form\Common\TagAutocompleteField;
use App\Form\Type\BaseTranslationsType;
use Arkounay\Bundle\UxCollectionBundle\Form\UxCollectionType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\FormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class BaseType extends AbstractType
{




    public function buildForm(FormBuilderInterface $builder, array $options): void
    {


        parent::buildForm($builder, $options);

        if ($options['data'] instanceof TranslatableInterface) {

            $builder->add('translations', BaseTranslationsType::class, [


            ]);
        }

        if ($options['data'] instanceof TagableInterface) {
            if (!$builder->has('relations')) {
                $builder->add($builder->create('relations', FormType::class, ['inherit_data' => true]));
            }

            $builder->get('relations')
                ->add('tags', TagAutocompleteField::class, [
                    'multiple' => true,
                    'required' => false
                ]);
        }

        if ($options['data'] instanceof MetableInterface) {
            $builder->add('meta', MetaType::class, [
                'required' => false
            ]);
        }

        if ($options['data'] instanceof BlockableInterface) {
            if (!$builder->has('content')) {
                $builder->add($builder->create('content', FormType::class, ['inherit_data' => true]));
            }

            $builder->get('content')
                ->add('blocks', UxCollectionType::class, [
                    'label' => false,
                    'entry_type' => BlockType::class,
                    'attr' => ['data-controller' => 'custom-collection'],
                    'allow_add' => true,
                    'allow_delete' => true,
                    'allow_drag_and_drop' => true,
                    'drag_and_drop_filter' => 'input,textarea,a,button,label',
                    'display_sort_buttons' => true,
                    'min' => 0
                ]);
        }

    }
}
